<?php

namespace AC;

use AC\ListScreenRepository\Sort;
use AC\Type\ListScreenId;
use WP_User;

interface ListScreenRepository {

	public function find( ListScreenId $id ): ?ListScreen;

	public function find_by_user( ListScreenId $id, WP_User $user ): ?ListScreen;

	public function exists( ListScreenId $id ): bool;

	public function find_all( Sort $sort = null ): ListScreenCollection;

	public function find_all_by_key( string $key, Sort $sort = null ): ListScreenCollection;

	public function find_all_by_user( string $key, WP_User $user, Sort $sort = null ): ListScreenCollection;

}